using System;
using System.IO;
using System.Security;
using System.Security.Cryptography;
using System.Collections.Generic;
using System.Text;

namespace SymmetricEncryption
{
   class Program
   {
      static void Main(string[] args)
      {
         RijndaelManaged rmCrypto = new RijndaelManaged();
         // klucze te s zupenie nieprawdziwe, w rozwizaniach praktycznych
         // nasze klucze i IV bd znacznie mniej oczywiste
         byte[] key = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
     0x09, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16 };
         byte[] IV = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
     0x09, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16 };

         string clearMessage =
           "Ten cig znakowy zostanie zaszyfrowany symetrycznie, a nastpnie odszyfrowany " +
           "z uyciem tego samego klucza.";

         FileStream fs = new FileStream("zaszyfrowany.dat", FileMode.Create);
         CryptoStream cs = new CryptoStream(
           fs, rmCrypto.CreateEncryptor(key, IV), CryptoStreamMode.Write);
         cs.Write(System.Text.Encoding.GetEncoding(1250).GetBytes(clearMessage),
           0, clearMessage.Length);
         cs.Close();
         fs.Close();

         // otwrz zaszyfrowanmy plik z uyciem innego strumienia
         // aby zaprezentowa symetryczne deszyfrowanie
         FileStream fs2 = new FileStream("zaszyfrowany.dat", FileMode.Open);
         CryptoStream cs2 = new CryptoStream(
           fs2, rmCrypto.CreateDecryptor(key, IV), CryptoStreamMode.Read);
         byte[] decryptedData = new byte[fs2.Length];
         cs2.Read(decryptedData, 0, (int)fs2.Length);
         cs2.Close();
         fs2.Close();
         Console.WriteLine("Odszyfrowana wiadomo:\n{0}",
           System.Text.Encoding.GetEncoding(1250).GetString(decryptedData));


         Console.ReadLine();
      }
   }
}
